/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.model;

import dev.toma.gunsrpg.client.model.component.AbstractAttachmentModel;
import dev.toma.gunsrpg.client.model.component.PSOScopeModel;
import dev.toma.gunsrpg.client.model.component.ReflexSightModel;
import dev.toma.gunsrpg.client.model.component.ScopeModel;
import dev.toma.gunsrpg.client.model.component.SuppressorModel;
import dev.toma.gunsrpg.client.model.weapon.AKMModel;
import dev.toma.gunsrpg.client.model.weapon.AbstractWeaponModel;
import dev.toma.gunsrpg.client.model.weapon.AugModel;
import dev.toma.gunsrpg.client.model.weapon.AwmModel;
import dev.toma.gunsrpg.client.model.weapon.ChuKoNuModel;
import dev.toma.gunsrpg.client.model.weapon.DesertEagleModel;
import dev.toma.gunsrpg.client.model.weapon.GrenadeLauncherModel;
import dev.toma.gunsrpg.client.model.weapon.HK416Model;
import dev.toma.gunsrpg.client.model.weapon.Kar98kModel;
import dev.toma.gunsrpg.client.model.weapon.M1911Model;
import dev.toma.gunsrpg.client.model.weapon.Mk14Model;
import dev.toma.gunsrpg.client.model.weapon.R45Model;
import dev.toma.gunsrpg.client.model.weapon.RocketLauncherModel;
import dev.toma.gunsrpg.client.model.weapon.S12kModel;
import dev.toma.gunsrpg.client.model.weapon.S1897Model;
import dev.toma.gunsrpg.client.model.weapon.S686Model;
import dev.toma.gunsrpg.client.model.weapon.SksModel;
import dev.toma.gunsrpg.client.model.weapon.ThompsonModel;
import dev.toma.gunsrpg.client.model.weapon.Ump45Model;
import dev.toma.gunsrpg.client.model.weapon.VectorModel;
import dev.toma.gunsrpg.client.model.weapon.VssModel;
import dev.toma.gunsrpg.client.model.weapon.WinchesterModel;
import dev.toma.gunsrpg.client.model.weapon.WoodenCrossbowModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lib.toma.animations.api.AnimationStage;

public final class WeaponModels {
    public static final AbstractWeaponModel M1911 = new M1911Model();
    public static final AbstractWeaponModel R45 = new R45Model();
    public static final AbstractWeaponModel DESERT_EAGLE = new DesertEagleModel();
    public static final AbstractWeaponModel WOODEN_CROSSBOW = new WoodenCrossbowModel();
    public static final AbstractWeaponModel CHU_KO_NU = new ChuKoNuModel();
    public static final AbstractWeaponModel UMP_45 = new Ump45Model();
    public static final AbstractWeaponModel THOMPSON = new ThompsonModel();
    public static final AbstractWeaponModel VECTOR = new VectorModel();
    public static final AbstractWeaponModel S1897 = new S1897Model();
    public static final AbstractWeaponModel S686 = new S686Model();
    public static final AbstractWeaponModel S12K = new S12kModel();
    public static final AbstractWeaponModel SKS = new SksModel();
    public static final AbstractWeaponModel VSS = new VssModel();
    public static final AbstractWeaponModel AKM = new AKMModel();
    public static final AbstractWeaponModel HK416 = new HK416Model();
    public static final AbstractWeaponModel AUG = new AugModel();
    public static final AbstractWeaponModel KAR98K = new Kar98kModel();
    public static final AbstractWeaponModel WINCHESTER = new WinchesterModel();
    public static final AbstractWeaponModel MK14 = new Mk14Model();
    public static final AbstractWeaponModel AWM = new AwmModel();
    public static final AbstractWeaponModel GRENADE_LAUNCHER = new GrenadeLauncherModel();
    public static final AbstractWeaponModel ROCKET_LAUNCHER = new RocketLauncherModel();
    public static final AbstractAttachmentModel SCOPE = new ScopeModel();
    public static final AbstractAttachmentModel SUPPRESSOR = new SuppressorModel();
    public static final AbstractAttachmentModel REFLEX = new ReflexSightModel();
    public static final AbstractAttachmentModel PSO_SCOPE = new PSOScopeModel();

    private WeaponModels() {
    }

    public static Map<AbstractWeaponModel, Collection<AnimationStage>> getSupportedPartAnimations() {
        List<AbstractWeaponModel> list = Arrays.asList(M1911, R45, DESERT_EAGLE, WOODEN_CROSSBOW, CHU_KO_NU, UMP_45, THOMPSON, VECTOR, S1897, S686, S12K, SKS, VSS, AKM, HK416, AUG, KAR98K, WINCHESTER, MK14, AWM, GRENADE_LAUNCHER, ROCKET_LAUNCHER);
        LinkedHashMap<AbstractWeaponModel, Collection<AnimationStage>> map = new LinkedHashMap<AbstractWeaponModel, Collection<AnimationStage>>();
        for (AbstractWeaponModel weaponModel : list) {
            map.put(weaponModel, weaponModel.getSpecialRenderers().stream().map(AbstractWeaponModel.SpecialRenderer::target).collect(Collectors.toList()));
        }
        return map;
    }
}

